/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.cpm;

import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.cpm.CpmFormatDisk;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class CpmFileEntry
implements FileEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int ENTRY_LENGTH = 32;
    public static final int MAX_EXTENTS_PER_ENTRY = 128;
    public static final int ALL_RECORDS_FILLED_SIZE = 16384;
    public static final int USER_NUMBER_OFFSET = 0;
    public static final int FILENAME_OFFSET = 1;
    public static final int FILENAME_LENGTH = 8;
    public static final int FILETYPE_OFFSET = 9;
    public static final int FILETYPE_LENGTH = 3;
    public static final int FILETYPE_T1_OFFSET = 9;
    public static final int FILETYPE_T2_OFFSET = 10;
    public static final int FILETYPE_T3_OFFSET = 11;
    public static final int EXTENT_COUNTER_OFFSET = 12;
    public static final int RECORD_COUNT_OFFSET = 15;
    public static final int ALLOCATION_OFFSET = 16;
    public static final String[] TEXT_FILETYPES = new String[]{"TXT", "ASM", "MAC", "DOC", "PRN", "PAS", "ME", "INC", "HLP"};
    private CpmFormatDisk disk;
    private List<Integer> offsets = new ArrayList<Integer>();

    public CpmFileEntry(CpmFormatDisk disk, int offset) {
        this.disk = disk;
        this.addOffset(offset);
    }

    public void addOffset(int offset) {
        this.offsets.add(new Integer(offset));
    }

    protected byte[] readFileEntry(int number) {
        byte[] data = new byte[2048];
        System.arraycopy(this.disk.readCpmBlock(0), 0, data, 0, 1024);
        System.arraycopy(this.disk.readCpmBlock(1), 0, data, 1024, 1024);
        byte[] entry = new byte[32];
        int offset = this.offsets.get(number);
        System.arraycopy(data, offset, entry, 0, 32);
        return entry;
    }

    protected void writeFileEntry(int number, byte[] data) {
        byte[] block = new byte[1024];
        System.arraycopy(data, 0, block, 0, 1024);
        this.disk.writeCpmBlock(0, block);
        System.arraycopy(data, 0, block, 1024, 1024);
        this.disk.writeCpmBlock(1, block);
    }

    @Override
    public String getFilename() {
        return AppleUtil.getString(this.readFileEntry(0), 1, 8).trim();
    }

    @Override
    public void setFilename(String filename) {
        for (int i = 0; i < this.offsets.size(); ++i) {
            byte[] data = this.readFileEntry(i);
            AppleUtil.setString(data, 1, filename, 8, false);
            this.writeFileEntry(i, data);
        }
    }

    @Override
    public String getFiletype() {
        return AppleUtil.getString(this.readFileEntry(0), 9, 3).trim();
    }

    @Override
    public void setFiletype(String filetype) {
        for (int i = 0; i < this.offsets.size(); ++i) {
            byte T1 = this.getFileTypeT1(i);
            byte T2 = this.getFileTypeT2(i);
            byte T3 = this.getFileTypeT3(i);
            byte[] data = this.readFileEntry(i);
            AppleUtil.setString(data, 9, filetype, 3, false);
            data[9] = (byte)(data[9] | (T1 > 127 ? 128 : 0));
            data[10] = (byte)(data[10] | (T2 > 127 ? 128 : 0));
            data[10] = (byte)(data[10] | (T3 > 127 ? 128 : 0));
        }
    }

    @Override
    public boolean isLocked() {
        return AppleUtil.isBitSet(this.getFileTypeT1(0), 7);
    }

    public byte getFileTypeT1(int entryNumber) {
        return this.readFileEntry(entryNumber)[9];
    }

    public void setFileTypeT1(int entryNumber, int t1) {
        byte[] data = this.readFileEntry(entryNumber);
        data[9] = (byte)t1;
        this.writeFileEntry(entryNumber, data);
    }

    public byte getFileTypeT2(int entryNumber) {
        return this.readFileEntry(entryNumber)[10];
    }

    public void setFileTypeT2(int entryNumber, int t2) {
        byte[] data = this.readFileEntry(entryNumber);
        data[10] = (byte)t2;
        this.writeFileEntry(entryNumber, data);
    }

    public byte getFileTypeT3(int entryNumber) {
        return this.readFileEntry(entryNumber)[11];
    }

    public void setFileTypeT3(int entryNumber, int t3) {
        byte[] data = this.readFileEntry(entryNumber);
        data[11] = (byte)t3;
        this.writeFileEntry(entryNumber, data);
    }

    @Override
    public void setLocked(boolean lock) {
        for (int i = 0; i < this.offsets.size(); ++i) {
            if (lock) {
                this.setFileTypeT1(i, this.getFileTypeT1(i) | 0x80);
                continue;
            }
            this.setFileTypeT1(i, this.getFileTypeT1(i) & 0x7F);
        }
    }

    public int getExtentCounterLow(int entryNumber) {
        return AppleUtil.getUnsignedByte(this.readFileEntry(entryNumber)[12]);
    }

    @Override
    public int getSize() {
        int entry = this.findLargestExtent();
        return this.getExtentCounterLow(entry) * 16384 + this.getNumberOfRecordsUsed(entry) * 128;
    }

    protected int findLargestExtent() {
        int entry = -1;
        for (int i = 0; i < this.offsets.size(); ++i) {
            if (entry < 0) {
                entry = i;
                continue;
            }
            int currentExtent = this.getExtentCounterLow(entry);
            int thisExtent = this.getExtentCounterLow(i);
            if (thisExtent <= currentExtent) continue;
            entry = i;
        }
        return entry;
    }

    public int getBlocksUsed() {
        int entry = this.findLargestExtent();
        return this.getExtentCounterLow(entry) * 16384 + (this.getNumberOfRecordsUsed(entry) - 1) / 8 + 1;
    }

    public int getNumberOfRecordsUsed(int entryNumber) {
        return AppleUtil.getUnsignedByte(this.readFileEntry(entryNumber)[15]);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return 229 == this.getUserNumber(0);
    }

    public int getUserNumber(int entryNumber) {
        return AppleUtil.getUnsignedByte(this.readFileEntry(entryNumber)[0]);
    }

    public void setUserNumber(int entryNumber, int userNumber) {
        byte[] data = this.readFileEntry(entryNumber);
        data[0] = (byte)userNumber;
        this.writeFileEntry(entryNumber, data);
    }

    @Override
    public void delete() {
        for (int i = 0; i < this.offsets.size(); ++i) {
            this.setUserNumber(i, 229);
        }
    }

    @Override
    public List<String> getFileColumnData(int displayMode) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        ArrayList<String> list = new ArrayList<String>();
        switch (displayMode) {
            case 2: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                break;
            }
            case 3: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                list.add(numberFormat.format(this.getSize()));
                list.add("0x" + AppleUtil.getFormattedByte(this.getUserNumber(0)));
                list.add(this.isDeleted() ? this.textBundle.get("Deleted") : "");
                list.add(this.isLocked() ? this.textBundle.get("Locked") : "");
                break;
            }
            default: {
                list.add(this.getFilename());
                list.add(this.getFiletype());
                list.add(numberFormat.format(this.getSize()));
                list.add(this.isLocked() ? this.textBundle.get("Locked") : "");
            }
        }
        return list;
    }

    @Override
    public byte[] getFileData() {
        return this.disk.getFileData(this);
    }

    @Override
    public void setFileData(byte[] data) throws DiskFullException {
    }

    @Override
    public FileFilter getSuggestedFilter() {
        String filetype = this.getFiletype();
        for (int i = 0; i < TEXT_FILETYPES.length; ++i) {
            if (!TEXT_FILETYPES[i].equals(filetype)) continue;
            return new TextFileFilter();
        }
        return new BinaryFileFilter();
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.disk;
    }

    @Override
    public int getMaximumFilenameLength() {
        return 8;
    }

    @Override
    public boolean needsAddress() {
        return this.disk.needsAddress(this.getFiletype());
    }

    @Override
    public void setAddress(int address) {
    }

    @Override
    public boolean canCompile() {
        return false;
    }

    public boolean isEmpty() {
        byte[] data = this.readFileEntry(0);
        for (int i = 0; i < 32; ++i) {
            int byt = AppleUtil.getUnsignedByte(data[i]);
            if (byt == 229) continue;
            return false;
        }
        return true;
    }

    public int[] getAllocations() {
        int blocks = this.getBlocksUsed();
        int[] allocations = new int[blocks];
        int block = 0;
        for (int i = 0; i < this.offsets.size(); ++i) {
            byte[] data = this.readFileEntry(i);
            int offset = 16;
            while (block < blocks && offset < 32) {
                allocations[block++] = AppleUtil.getUnsignedByte(data[offset++]);
            }
        }
        return allocations;
    }
}

